<?php

namespace App\Traits;

use App\Libraries\AppLibrary;
use Exception;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Config;

trait ApiRequestTrait
{
    public function makeApiRequest()
    {
        try {
            // رابط التحقق من الترخيص
            $licenseUrl = 'https://license.hugous.com/';
            
            // دومين التطبيق الحالي
            $currentDomain = AppLibrary::domain(Config('app.url'));

            // إرسال طلب التحقق
            $response = Http::post($licenseUrl, [
                'hugous' => true, // المفتاح للتحقق
                'domain' => $currentDomain,
            ]);

            // تحقق إذا كان الطلب ناجحًا
            if ($response->successful()) {
                $responseData = $response->json();

                // تحقق إذا كان الدومين مصرحًا له
                if (in_array($currentDomain, $responseData)) {
                    return (object)[
                        'status' => true,
                        'message' => 'Domain is authorized',
                    ];
                }

                return (object)[
                    'status' => false,
                    'message' => 'Unauthorized domain',
                ];
            }

            // إذا فشل الطلب
            return (object)[
                'status' => false,
                'message' => 'Failed to connect to the license server',
            ];
        } catch (Exception $exception) {
            Log::info($exception->getMessage());
            return (object)[
                'status' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }
}
