import * as vue from 'vue';
import { VNode } from 'vue';

type Breakpoints = { [key: number]: Partial<CarouselConfig> }

type SnapAlign = 'start' | 'end' | 'center' | 'center-even' | 'center-odd'

type Dir = 'rtl' | 'ltr'
interface CarouselConfig {
  itemsToShow: number
  itemsToScroll: number
  modelValue?: number
  transition?: number
  throttle: number
  autoplay?: number
  snapAlign: SnapAlign
  wrapAround?: boolean
  pauseAutoplayOnHover?: boolean
  mouseDrag?: boolean
  touchDrag?: boolean
  dir?: Dir
  breakpoints?: Breakpoints
  settings?: Partial<CarouselConfig>
}

declare const _default$1: vue.DefineComponent<{
    itemsToShow: {
        default: number;
        type: NumberConstructor;
    };
    itemsToScroll: {
        default: number;
        type: NumberConstructor;
    };
    wrapAround: {
        default: boolean | undefined;
        type: BooleanConstructor;
    };
    throttle: {
        default: number;
        type: NumberConstructor;
    };
    snapAlign: {
        default: SnapAlign;
        validator(value: string): boolean;
    };
    transition: {
        default: number | undefined;
        type: NumberConstructor;
    };
    breakpoints: {
        default: Breakpoints | undefined;
        type: ObjectConstructor;
    };
    autoplay: {
        default: number | undefined;
        type: NumberConstructor;
    };
    pauseAutoplayOnHover: {
        default: boolean | undefined;
        type: BooleanConstructor;
    };
    modelValue: {
        default: undefined;
        type: NumberConstructor;
    };
    mouseDrag: {
        default: boolean | undefined;
        type: BooleanConstructor;
    };
    touchDrag: {
        default: boolean | undefined;
        type: BooleanConstructor;
    };
    dir: {
        default: Dir | undefined;
        validator(value: string): boolean;
    };
    settings: {
        default(): {};
        type: ObjectConstructor;
    };
}, () => VNode<vue.RendererNode, vue.RendererElement, {
    [key: string]: any;
}>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {}, string, vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps, Readonly<vue.ExtractPropTypes<{
    itemsToShow: {
        default: number;
        type: NumberConstructor;
    };
    itemsToScroll: {
        default: number;
        type: NumberConstructor;
    };
    wrapAround: {
        default: boolean | undefined;
        type: BooleanConstructor;
    };
    throttle: {
        default: number;
        type: NumberConstructor;
    };
    snapAlign: {
        default: SnapAlign;
        validator(value: string): boolean;
    };
    transition: {
        default: number | undefined;
        type: NumberConstructor;
    };
    breakpoints: {
        default: Breakpoints | undefined;
        type: ObjectConstructor;
    };
    autoplay: {
        default: number | undefined;
        type: NumberConstructor;
    };
    pauseAutoplayOnHover: {
        default: boolean | undefined;
        type: BooleanConstructor;
    };
    modelValue: {
        default: undefined;
        type: NumberConstructor;
    };
    mouseDrag: {
        default: boolean | undefined;
        type: BooleanConstructor;
    };
    touchDrag: {
        default: boolean | undefined;
        type: BooleanConstructor;
    };
    dir: {
        default: Dir | undefined;
        validator(value: string): boolean;
    };
    settings: {
        default(): {};
        type: ObjectConstructor;
    };
}>>, {
    itemsToShow: number;
    itemsToScroll: number;
    wrapAround: boolean;
    throttle: number;
    snapAlign: "start" | "end" | "center" | "center-even" | "center-odd";
    transition: number;
    breakpoints: Record<string, any>;
    autoplay: number;
    pauseAutoplayOnHover: boolean;
    modelValue: number;
    mouseDrag: boolean;
    touchDrag: boolean;
    dir: "rtl" | "ltr";
    settings: Record<string, any>;
}>;

interface Data {
    [key: string]: unknown;
}

declare const Icon: {
    (props: Data): vue.VNode<vue.RendererNode, vue.RendererElement, {
        [key: string]: any;
    }> | undefined;
    props: {
        name: StringConstructor;
        title: StringConstructor;
    };
};

declare const Navigation: (props: any, { slots, attrs }: any) => vue.VNode<vue.RendererNode, vue.RendererElement, {
    [key: string]: any;
}>[];

declare const Pagination: () => VNode<vue.RendererNode, vue.RendererElement, {
    [key: string]: any;
}>;

declare const _default: vue.DefineComponent<{
    index: {
        type: NumberConstructor;
        default: number;
    };
    isClone: {
        type: BooleanConstructor;
        default: boolean;
    };
}, () => vue.VNode<vue.RendererNode, vue.RendererElement, {
    [key: string]: any;
}>, unknown, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {}, string, vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps, Readonly<vue.ExtractPropTypes<{
    index: {
        type: NumberConstructor;
        default: number;
    };
    isClone: {
        type: BooleanConstructor;
        default: boolean;
    };
}>>, {
    index: number;
    isClone: boolean;
}>;

export { _default$1 as Carousel, Icon, Navigation, Pagination, _default as Slide };
